/** @file   tileid.cpp
 * @brief   Implementation of TileID - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#include "tileid.h"
#include <fstream>


namespace WeWantWar {

///
/// Static members, constants and datatypes
/// =======================================

int TileID::id[256] = {
  // player
  1,
  
  // aliens
  16, // carnivore
  17, // small worm
  18, // winged
  19, // ?
  20, // proctor
  21, // minigun
  22,
  23,
  24,
  25,

  // gasleak
  30,
  
  // doors
  64, 65,
  
  // bonus items
  32, // rifle
  33, // shotgun
  34, // grenade
  35, // firstaid
  36, // flamethrower
  37, // minigun
  38, // uzi
  
  66  // static light
};


/** Loads the tile id codes from given file.
 */
void TileID::loadIDCodes( const std::string& tileidfile )
{
  std::ifstream fin( tileidfile.c_str() );
  if ( !fin ) {
    return;
  }
  
  std::string tmp;
  while ( true ) {
    if ( fin.eof() == true ) {
      fin.close();
      return;
    }
    
    fin >> tmp;
    if ( tmp == "#" ) {
      fin.ignore( 4096, '\n' );
      
    } else if ( tmp == "<wewantwar_tileid>" ) {
      break;
      
    }
  }
  
  // We found the opening tag.
  while ( true ) {
    if ( fin.eof() == true ) {
      fin.close();
      return;
    }
    fin >> tmp;
    if ( tmp == "#" ) {
      fin.ignore( 4096, '\n' );
    } else if ( tmp == "</wewantwar_tileid>" || tmp == "[END]" ) {
      fin.close();
      return;
    } else if ( tmp == "tileid_player:" ) {
      fin >> id[ID_PLAYER];
      
    } else if ( tmp == "tileid_alien1:" ) {
      fin >> id[ID_ALIEN1];
      
    } else if ( tmp == "tileid_alien2:" ) {
      fin >> id[ID_ALIEN2];
      
    } else if ( tmp == "tileid_alien3:" ) {
      fin >> id[ID_ALIEN3];
      
    } else if ( tmp == "tileid_alien4:" ) {
      fin >> id[ID_ALIEN4];
      
    } else if ( tmp == "tileid_alien5:" ) {
      fin >> id[ID_ALIEN5];
      
    } else if ( tmp == "tileid_alien6:" ) {
      fin >> id[ID_ALIEN6];
      
    } else if ( tmp == "tileid_alien7:" ) {
      fin >> id[ID_ALIEN7];
      
    } else if ( tmp == "tileid_gasleak:" ) {
      fin >> id[ID_GASLEAK];
      
    } else if ( tmp == "tileid_vs_door:" ) {
      fin >> id[ID_VS_DOOR];
      
    } else if ( tmp == "tileid_hs_door:" ) {
      fin >> id[ID_HS_DOOR];
      
    } else if ( tmp == "tileid_bonus_rifle:" ) {
      fin >> id[ID_BONUS_RIFLE];
      
    } else if ( tmp == "tileid_bonus_shotgun:" ) {
      fin >> id[ID_BONUS_SHOTGUN];
      
    } else if ( tmp == "tileid_bonus_grenade:" ) {
      fin >> id[ID_BONUS_GRENADE];
      
    } else if ( tmp == "tileid_bonus_firstaid:" ) {
      fin >> id[ID_BONUS_FIRSTAID];
      
    } else if ( tmp == "tileid_bonus_flamethrower:" ) {
      fin >> id[ID_BONUS_FLAMETHROWER];
      
    } else if ( tmp == "tileid_bonus_minigun:" ) {
      fin >> id[ID_BONUS_MINIGUN];
      
    } else if ( tmp == "tileid_bonus_uzi:" ) {
      fin >> id[ID_BONUS_UZI];
      
    } else if ( tmp == "tileid_static_light:" ) {
      fin >> id[ID_STATIC_LIGHT];
      
    }
  }
}


/** Constructor
 */
TileID::TileID()
{
}



/** Destructor
 */
TileID::~TileID()
{
}


} // end of namespace
